;Copyright 1997, 1999 by Henter-Joyce, Inc.
;Modified and updated 3/30/99 by DB
Include "hjglobal.jsh" ; default HJ global variables
Include "hjconst.jsh" ; default HJ constants
include "qw.jsm" ; message file
include "QW.jsh"; Header file
Globals
	int QuickenFirstTime,
	int PreviousTreeViewLevel, ; only announce treeview level when it changes
	Handle ToolTipsHandle, ;Stores the handle for any tool tip that appears on the  screen.
	Handle BalanceHandle, ; storres the ending balance
	Int DefaultTypingEcho, ;Stores the default typing echo,
	String ToolTip,
	String balance 
const
	;UT_OutputModes
	UT_SAYTYPEANDTEXT = 0,
	UT_FOCUS = 1,
	UT_CONTROLID = 2,
	UT_CLASS = 3,
	UT_TYPE = 4,
	UT_SUBTYPE = 5,
	UT_REALNAME = 6,
	WC_ToolTip = "QWGCCardViewClass",
	WC_Balance="static"

Void Function AutoStartEvent ()

Let DefaultTypingEcho = GetDefaultJCFOption (OPT_TYPING_ECHO) ;init the keyboard typing echo variable.
Let ToolTip = WC_ToolTip 

if (QuickenFirstTime == 0) then
	let QuickenFirstTime = 1
	If (GetVerbosity() == BEGINNER) then
		Say (msg371, OT_HELP) ;"for screen sensitive help Press insert + f1"
		Say (msg372, OT_HELP) ;"for JAWS Help Keys or help in dialog boxes Press Insert + H"
		Say (msg373, OT_HELP) ;"for a summary of windows short cut keys Press insert + W"
		Say (msg427, OT_HELP) ; "for best results turn on the quicken QCards"
	EndIf
endif 	;QuickenFirstTime == 0
EndFunction

Script HotKeyHelp ()
;Script for hot key help
Say (msg428, OT_HELP) ; "For optimum results with Quicken 98  scripts, maximize Quicken, and turn on the QCards."
Say (msg429 + GetScriptKeyName ("SayEndingBalance"), OT_HELP) ; "press control plus insert plus E to hear the current ending balance"
Say (msg430 + GetScriptKeyName ("ScreenSensitiveHelp"), OT_HELP) ; "press insert plus F1 for screen sensitive help"
EndScript

Script ScreenSensitiveHelp ()
var
	handle WinHandle,
	string TheClass,
	int CId
let WinHandle = GetCurrentWindow ()
let TheClass = GetWindowClass (WinHandle)
;wc1 = "QREdit"
if (IsSameScript ()) then
	AppFileTopic()
	return
EndIf
if (TheClass ==wc1) then
	Say (msg431, OT_HELP) ; ; "You can type information in this field or press down arrow to move through a list in many cases"
	return
EndIf
PerformScript ScreenSensitiveHelp ()
EndScript

Script ScriptFileName ()
ScriptAndAppNames ("Quicken 98")
EndScript

Void Function SayHighLightedText (handle hwnd, string buffer)
; HighlightedText event macro for speaking all newly written highlighted
; text.
if(GetScreenEcho() > 0) then
	if (GetWindowSubTypeCode (hwnd) == WT_TREEVIEW) && (GetTreeViewLevel() !=PreviousTreeviewLevel) then
		SayInteger(GetTreeViewLevel ())
	endIf
	Say (buffer, OT_BUFFER)
EndIf
EndFunction

Void Function SayNonHighlightedText (handle hwnd, string buffer)
var
	string TheClass
let TheClass = GetWindowClass(hwnd)
if ((GetScreenEcho() > 1)
   ;wn36="#32771"
   || (TheClass == wn36 )) then
	Say (buffer, OT_BUFFER)
EndIf
;Obtains tool tip window handle when appears, zero is return if not found.
If (TheClass == ToolTip) Then
	let ToolTipsHandle = Hwnd 
	endif
if (GetWindowSubtypeCode (Hwnd) == WT_PASSWORDEDIT) then ;#42
	Say (buffer, OT_BUFFER)
EndIf
if (GetWindowSubTypeCode (hwnd) == WT_TREEVIEW) && (GetTreeViewLevel() !=PreviousTreeviewLevel) then
	SayInteger(GetTreeViewLevel ())
endIf
EndFunction

Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
;focus change script,  
var
	handle RealWindow,
	string RealWindowName,
	handle AppWindow

let RealWindow = GetRealWindow(FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow(FocusWindow)
;msg442 = "Bank"
if StringContains (RealWindowName, msg442)
 then
 Pause()
	SayWindow (ToolTipsHandle, 0)
elif
;wn443 = "Write Checks: PCChecking"
RealWindowName== wn443 then
SayWriteChecks()
endif
if (GlobalPrevApp != AppWindow
   && AppWindow != FocusWindow) then 
	; we've switched to a different app main window, 
	; and it does not have the focus, so announce it
	SayWindowTypeAndText(AppWindow)
endif
If ((GlobalPrevRealName != RealWindowName) ; name has changed
   || (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
	If ((RealWindow != AppWindow)
	   && (RealWindow != FocusWindow)) then
		SayWindowTypeAndText(RealWindow)
	endif
EndIf
;no matter what, say the window with focus
;but do it by calling a subroutine that can be special for each application, 
let GlobalFocusWindow = FocusWindow
SayFocusedWindow()  ; will use global variable "GlobalFocusWindow"
;above perform will return here to finish this routine
;now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
EndFunction

Void Function SayFocusedWindow ()
SayWindowTypeAndText (GlobalFocusWindow)
EndFunction

Script SayEndingBalance ()
; When the hotkey is pressed says the ending balance in the register screen 
SaveCursor ()
InvisibleCursor ()
JAWSPageDown ()
PriorLine ()
PriorLine()
SayLine ()
RestoreCursor ()
endScript

Function SayWriteChecks ()
; Reads the fields in the write checks screen
if  GetControlID (GetFocus ())==2000
then
	Say (msg432, OT_MESSAGE) ; "date"
elif
	 GetControlID (GetFocus ())==2001
Then
	Say (msg433, OT_MESSAGE) ; "pay to the order of")
elif
		 GetControlID (GetFocus ())==2002
then 
	Say (msg434, OT_MESSAGE) ; "amount"
elif
	 GetControlID (GetFocus ())==2003
then
	Say (msg435, OT_MESSAGE) ; "address1"
elif
	 GetControlID (GetFocus ())==2004
then
	Say (msg436, OT_MESSAGE) ; "address2"
elif
	 GetControlID (GetFocus ())==2005
then
	Say (msg437, OT_MESSAGE) ; "address3"
elif
	 GetControlID (GetFocus ())==2006
then
	Say (msg438, OT_MESSAGE) ; "address4"
elif
	 GetControlID (GetFocus ())==2007
then
	Say (msg439, OT_MESSAGE) ; "address5"
elif
	 GetControlID (GetFocus ())==2008
then
	Say (msg440, OT_MESSAGE) ; "memo"
elif
	 GetControlID (GetFocus ())==2020
then
	Say (msg441, OT_MESSAGE) ; "Category list"
endif
EndFunction
